/*
 * Decompiled with CFR 0.152.
 */
package me.redstoner2019.streamingclient.capture;

import java.util.ArrayList;
import java.util.List;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioDeviceLister {
    private static final Logger logger = LoggerFactory.getLogger(AudioDeviceLister.class);

    public static List<String> listAudioDevices() {
        ArrayList<String> devices = new ArrayList<String>();
        try {
            block5: {
                avutil.av_log_set_level(32);
                logger.info("Attempting to list DirectShow audio devices...");
                try {
                    FFmpegFrameGrabber grabber = new FFmpegFrameGrabber("dummy");
                    grabber.setFormat("dshow");
                    grabber.setOption("list_devices", "true");
                    grabber.start();
                }
                catch (Exception e) {
                    String errorMsg = e.getMessage();
                    if (errorMsg == null) break block5;
                    logger.info("FFmpeg output: {}", (Object)errorMsg);
                    AudioDeviceLister.parseDevicesFromError(errorMsg, devices);
                }
            }
            if (devices.isEmpty()) {
                logger.info("Trying alternative device detection...");
                devices.addAll(AudioDeviceLister.tryCommonDeviceNames());
            }
        }
        catch (Exception e) {
            logger.error("Error listing audio devices", e);
        }
        return devices;
    }

    private static void parseDevicesFromError(String errorMsg, List<String> devices) {
        String[] lines;
        for (String line : lines = errorMsg.split("\n")) {
            if (!line.contains("(audio)") || !line.contains("\"")) continue;
            int start = line.indexOf("\"");
            int end = line.indexOf("\"", start + 1);
            if (start < 0 || end <= start) continue;
            String deviceName = line.substring(start + 1, end);
            devices.add(deviceName);
            logger.info("Found audio device: {}", (Object)deviceName);
        }
    }

    private static List<String> tryCommonDeviceNames() {
        String[] commonNames;
        ArrayList<String> workingDevices = new ArrayList<String>();
        for (String deviceName : commonNames = new String[]{"Stereo Mix", "What U Hear", "Wave Out Mix", "Rec. Playback", "Loopback", "Microphone", "Line In", "CABLE Output", "VB-Audio Virtual Cable"}) {
            try {
                FFmpegFrameGrabber test = new FFmpegFrameGrabber("audio=" + deviceName);
                test.setFormat("dshow");
                test.setSampleRate(44100);
                test.start();
                test.stop();
                test.close();
                workingDevices.add(deviceName);
                logger.info("Device '{}' is available", (Object)deviceName);
            }
            catch (Exception e) {
                logger.debug("Device '{}' not available: {}", (Object)deviceName, (Object)e.getMessage());
            }
        }
        return workingDevices;
    }

    public static void main(String[] args2) {
        System.out.println("=== Available DirectShow Audio Devices ===");
        List<String> devices = AudioDeviceLister.listAudioDevices();
        if (devices.isEmpty()) {
            System.out.println("No audio input devices found!");
            System.out.println("\nTo enable desktop audio capture:");
            System.out.println("1. Right-click sound icon in system tray");
            System.out.println("2. Click 'Sounds' > 'Recording' tab");
            System.out.println("3. Right-click in window > 'Show Disabled Devices'");
            System.out.println("4. Enable 'Stereo Mix' or 'What U Hear'");
        } else {
            System.out.println("\nFound " + devices.size() + " device(s):");
            for (int i = 0; i < devices.size(); ++i) {
                System.out.println("  " + (i + 1) + ". " + devices.get(i));
            }
        }
    }
}

