/*
 * Decompiled with CFR 0.152.
 */
package me.redstoner2019.streamingclient.capture;

import me.redstoner2019.streamingclient.capture.AudioCapture;
import me.redstoner2019.streamingclient.capture.wasapi.WASAPILoopbackCapture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopAudioCapture {
    private static final Logger logger = LoggerFactory.getLogger(DesktopAudioCapture.class);
    private WASAPILoopbackCapture wasapiCapture;
    private boolean capturing = false;
    private AudioCapture.AudioDataListener audioDataListener;

    public void setAudioDataListener(AudioCapture.AudioDataListener listener) {
        this.audioDataListener = listener;
    }

    public void startCapture() throws Exception {
        if (this.capturing) {
            logger.warn("Desktop audio capture already running");
            return;
        }
        logger.info("Starting Windows WASAPI loopback audio capture...");
        try {
            this.wasapiCapture = new WASAPILoopbackCapture();
            this.wasapiCapture.setAudioDataListener(this.audioDataListener);
            this.wasapiCapture.startCapture();
            this.capturing = true;
            logger.info("WASAPI loopback capture started successfully");
        }
        catch (Exception e) {
            logger.error("Failed to start WASAPI loopback: {}", (Object)e.getMessage());
            this.wasapiCapture = null;
            throw new Exception("Failed to start desktop audio capture: " + e.getMessage());
        }
    }

    public void stopCapture() {
        if (!this.capturing) {
            return;
        }
        this.capturing = false;
        if (this.wasapiCapture != null) {
            try {
                this.wasapiCapture.stopCapture();
            }
            catch (Exception e) {
                logger.error("Error stopping WASAPI capture", e);
            }
            this.wasapiCapture = null;
        }
        logger.info("Desktop audio capture stopped");
    }

    public boolean isCapturing() {
        return this.capturing;
    }
}

