/*
 * Decompiled with CFR 0.152.
 */
package me.redstoner2019.streamingclient.capture;

public enum QualityPreset {
    LOW("Low", 640, 360, 15),
    MEDIUM("Medium", 1280, 720, 30),
    HIGH("High", 1920, 1080, 30),
    ULTRA("Ultra", 1920, 1080, 60),
    FOUR_K("4K", 3840, 2160, 30),
    CUSTOM("Custom", 1920, 1080, 30);

    private final String displayName;
    private int width;
    private int height;
    private int fps;

    private QualityPreset(String displayName, int width, int height, int fps) {
        this.displayName = displayName;
        this.width = width;
        this.height = height;
        this.fps = fps;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFps() {
        return this.fps;
    }

    public void setCustomValues(int width, int height, int fps) {
        if (this == CUSTOM) {
            this.width = width;
            this.height = height;
            this.fps = fps;
        }
    }

    public String toString() {
        return String.format("%s (%dx%d @ %dfps)", this.displayName, this.width, this.height, this.fps);
    }
}

