/*
 * Decompiled with CFR 0.152.
 */
package me.redstoner2019.streamingclient.capture.wasapi;

import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import me.redstoner2019.streamingclient.capture.AudioCapture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WASAPILoopbackCapture {
    private static final Logger logger = LoggerFactory.getLogger(WASAPILoopbackCapture.class);
    private static final int AUDCLNT_STREAMFLAGS_LOOPBACK = 131072;
    private static final int AUDCLNT_STREAMFLAGS_EVENTCALLBACK = 262144;
    private static final long REFTIMES_PER_SEC = 10000000L;
    private static final long REFTIMES_PER_MILLISEC = 10000L;
    private static final Guid.GUID CLSID_MMDeviceEnumerator = new Guid.GUID("BCDE0395-E52F-467C-8E3D-C4579291692E");
    private static final Guid.GUID IID_IMMDeviceEnumerator = new Guid.GUID("A95664D2-9614-4F35-A746-DE8DB63617E6");
    private static final Guid.GUID IID_IAudioClient = new Guid.GUID("1CB9AD4C-DBFA-4c32-B178-C2F568A703B2");
    private static final Guid.GUID IID_IAudioCaptureClient = new Guid.GUID("C8ADBD64-E71E-48a0-A4DE-185C395CD317");
    private volatile boolean capturing = false;
    private Thread captureThread;
    private AudioCapture.AudioDataListener audioDataListener;
    private Pointer deviceEnumerator;
    private Pointer device;
    private Pointer audioClient;
    private Pointer captureClient;
    private Pointer waveFormat;

    public void setAudioDataListener(AudioCapture.AudioDataListener listener) {
        this.audioDataListener = listener;
    }

    public void startCapture() throws Exception {
        if (this.capturing) {
            logger.warn("WASAPI capture already running");
            return;
        }
        logger.info("Initializing Windows WASAPI loopback capture...");
        this.capturing = true;
        this.captureThread = new Thread(this::captureLoop, "WASAPI-Loopback-Thread");
        this.captureThread.setDaemon(true);
        this.captureThread.start();
    }

    public void stopCapture() {
        if (!this.capturing) {
            return;
        }
        logger.info("Stopping WASAPI capture...");
        this.capturing = false;
        if (this.captureThread != null) {
            try {
                this.captureThread.join(3000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.captureThread = null;
        }
        this.cleanup();
        logger.info("WASAPI capture stopped");
    }

    private void captureLoop() {
        try {
            WinNT.HRESULT hr = Ole32.INSTANCE.CoInitializeEx(null, 0);
            if (hr.intValue() != 0 && hr.intValue() != 1) {
                logger.error("Failed to initialize COM: 0x{}", (Object)Integer.toHexString(hr.intValue()));
                return;
            }
            try {
                if (!this.initializeWASAPI()) {
                    logger.error("Failed to initialize WASAPI");
                    return;
                }
                logger.info("WASAPI loopback capture started successfully");
                this.runCaptureLoop();
            }
            finally {
                this.cleanup();
                Ole32.INSTANCE.CoUninitialize();
            }
        }
        catch (Exception e) {
            logger.error("Error in WASAPI capture thread", e);
        }
    }

    private boolean initializeWASAPI() {
        try {
            PointerByReference ppvPtr = new PointerByReference();
            WinNT.HRESULT hr = Ole32.INSTANCE.CoCreateInstance(CLSID_MMDeviceEnumerator, null, 7, IID_IMMDeviceEnumerator, ppvPtr);
            if (hr.intValue() != 0) {
                logger.error("Failed to create device enumerator: 0x{}", (Object)Integer.toHexString(hr.intValue()));
                return false;
            }
            this.deviceEnumerator = ppvPtr.getValue();
            logger.debug("Created device enumerator");
            PointerByReference devicePtr = new PointerByReference();
            hr = this.callCOMMethod(this.deviceEnumerator, 4, 0, 0, devicePtr);
            if (hr.intValue() != 0) {
                logger.error("Failed to get default audio endpoint: 0x{}", (Object)Integer.toHexString(hr.intValue()));
                return false;
            }
            this.device = devicePtr.getValue();
            logger.debug("Got default audio device");
            PointerByReference audioClientPtr = new PointerByReference();
            Pointer iidAudioClient = IID_IAudioClient.getPointer();
            hr = this.callCOMMethod(this.device, 3, iidAudioClient, 7, null, audioClientPtr);
            if (hr.intValue() != 0) {
                logger.error("Failed to activate audio client: 0x{}", (Object)Integer.toHexString(hr.intValue()));
                return false;
            }
            this.audioClient = audioClientPtr.getValue();
            logger.debug("Activated audio client");
            PointerByReference formatPtr = new PointerByReference();
            hr = this.callCOMMethod(this.audioClient, 8, formatPtr);
            if (hr.intValue() != 0) {
                logger.error("Failed to get mix format: 0x{}", (Object)Integer.toHexString(hr.intValue()));
                return false;
            }
            this.waveFormat = formatPtr.getValue();
            short formatTag = this.waveFormat.getShort(0L);
            short channels = this.waveFormat.getShort(2L);
            int samplesPerSec = this.waveFormat.getInt(4L);
            short bitsPerSample = this.waveFormat.getShort(14L);
            logger.info("Audio format: {} Hz, {} channels, {} bits", samplesPerSec, channels, bitsPerSample);
            long bufferDuration = 10000000L;
            hr = this.callCOMMethod(this.audioClient, 3, 0, 131072, bufferDuration, 0L, this.waveFormat, null);
            if (hr.intValue() != 0) {
                logger.error("Failed to initialize audio client: 0x{}", (Object)Integer.toHexString(hr.intValue()));
                return false;
            }
            logger.debug("Initialized audio client in loopback mode");
            PointerByReference captureClientPtr = new PointerByReference();
            Pointer iidCaptureClient = IID_IAudioCaptureClient.getPointer();
            hr = this.callCOMMethod(this.audioClient, 14, iidCaptureClient, captureClientPtr);
            if (hr.intValue() != 0) {
                logger.error("Failed to get capture client: 0x{}", (Object)Integer.toHexString(hr.intValue()));
                return false;
            }
            this.captureClient = captureClientPtr.getValue();
            logger.debug("Got capture client");
            hr = this.callCOMMethod(this.audioClient, 10, new Object[0]);
            if (hr.intValue() != 0) {
                logger.error("Failed to start audio client: 0x{}", (Object)Integer.toHexString(hr.intValue()));
                return false;
            }
            logger.debug("Started audio client");
            return true;
        }
        catch (Exception e) {
            logger.error("Exception during WASAPI initialization", e);
            return false;
        }
    }

    private void runCaptureLoop() {
        logger.info("Starting capture loop...");
        block3: while (this.capturing) {
            try {
                Thread.sleep(10L);
                IntByReference numFramesAvailable = new IntByReference();
                WinNT.HRESULT hr = this.callCOMMethod(this.captureClient, 5, numFramesAvailable);
                if (hr.intValue() != 0) continue;
                while (numFramesAvailable.getValue() > 0 && this.capturing) {
                    PointerByReference dataPtr = new PointerByReference();
                    IntByReference numFramesToRead = new IntByReference();
                    IntByReference flags = new IntByReference();
                    PointerByReference devicePosition = new PointerByReference();
                    PointerByReference qpcPosition = new PointerByReference();
                    hr = this.callCOMMethod(this.captureClient, 3, dataPtr, numFramesToRead, flags, devicePosition, qpcPosition);
                    if (hr.intValue() == 0) {
                        int framesToRead = numFramesToRead.getValue();
                        if (framesToRead > 0) {
                            Pointer data = dataPtr.getValue();
                            short channels = this.waveFormat.getShort(2L);
                            short bitsPerSample = this.waveFormat.getShort(14L);
                            int bytesPerFrame = channels * (bitsPerSample / 8);
                            int bytesToRead = framesToRead * bytesPerFrame;
                            byte[] audioData = data.getByteArray(0L, bytesToRead);
                            if (bitsPerSample == 32) {
                                audioData = this.convertFloat32ToPCM16(audioData, channels);
                            }
                            if (this.audioDataListener != null && audioData.length > 0) {
                                this.audioDataListener.onAudioData(audioData, audioData.length);
                            }
                        }
                        this.callCOMMethod(this.captureClient, 4, numFramesToRead.getValue());
                    }
                    if ((hr = this.callCOMMethod(this.captureClient, 5, numFramesAvailable)).intValue() == 0) continue;
                    continue block3;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                if (!this.capturing) continue;
                logger.error("Error in capture loop", e);
            }
        }
        logger.info("Capture loop ended");
    }

    private WinNT.HRESULT callCOMMethod(Pointer obj, int methodIndex, Object ... args2) {
        Pointer vtablePtr = obj.getPointer(0L);
        Pointer methodPtr = vtablePtr.getPointer(methodIndex * Native.POINTER_SIZE);
        Function func = Function.getFunction(methodPtr);
        Object[] fullArgs = new Object[args2.length + 1];
        fullArgs[0] = obj;
        System.arraycopy(args2, 0, fullArgs, 1, args2.length);
        int result = func.invokeInt(fullArgs);
        return new WinNT.HRESULT(result);
    }

    private void releaseCOM(Pointer obj) {
        if (obj != null) {
            try {
                this.callCOMMethod(obj, 2, new Object[0]);
            }
            catch (Exception e) {
                logger.warn("Error releasing COM object", e);
            }
        }
    }

    private byte[] convertFloat32ToPCM16(byte[] floatData, int channels) {
        int floatSampleCount = floatData.length / 4;
        byte[] pcmData = new byte[floatSampleCount * 2];
        for (int i = 0; i < floatSampleCount; ++i) {
            int offset = i * 4;
            int floatBits = floatData[offset] & 0xFF | (floatData[offset + 1] & 0xFF) << 8 | (floatData[offset + 2] & 0xFF) << 16 | (floatData[offset + 3] & 0xFF) << 24;
            float floatSample = Float.intBitsToFloat(floatBits);
            if (floatSample > 1.0f) {
                floatSample = 1.0f;
            }
            if (floatSample < -1.0f) {
                floatSample = -1.0f;
            }
            short pcmSample = (short)(floatSample * 32767.0f);
            int pcmOffset = i * 2;
            pcmData[pcmOffset] = (byte)(pcmSample & 0xFF);
            pcmData[pcmOffset + 1] = (byte)(pcmSample >> 8 & 0xFF);
        }
        return pcmData;
    }

    private void cleanup() {
        try {
            if (this.audioClient != null) {
                this.callCOMMethod(this.audioClient, 11, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.warn("Error stopping audio client", e);
        }
        this.releaseCOM(this.captureClient);
        this.captureClient = null;
        if (this.waveFormat != null) {
            try {
                Ole32.INSTANCE.CoTaskMemFree(this.waveFormat);
            }
            catch (Exception e) {
                logger.warn("Error freeing wave format", e);
            }
            this.waveFormat = null;
        }
        this.releaseCOM(this.audioClient);
        this.audioClient = null;
        this.releaseCOM(this.device);
        this.device = null;
        this.releaseCOM(this.deviceEnumerator);
        this.deviceEnumerator = null;
    }

    public boolean isCapturing() {
        return this.capturing;
    }
}

