/*
 * Decompiled with CFR 0.152.
 */
package me.redstoner2019.streamingclient.ui;

import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import me.redstoner2019.streamingclient.ui.StreamerTab;
import me.redstoner2019.streamingclient.ui.ViewerTab;

public class MainWindow {
    private final Stage stage;
    private TabPane tabPane;
    private StreamerTab streamerTab;
    private ViewerTab viewerTab;

    public MainWindow(Stage stage) {
        this.stage = stage;
        this.initializeUI();
    }

    private void initializeUI() {
        this.stage.setTitle("Streaming Client");
        this.stage.setMinWidth(900.0);
        this.stage.setMinHeight(700.0);
        BorderPane root = new BorderPane();
        root.setPadding(new Insets(10.0));
        this.tabPane = new TabPane();
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.streamerTab = new StreamerTab();
        this.viewerTab = new ViewerTab();
        Tab streamTab = new Tab("Streamer", this.streamerTab.getContent());
        Tab viewTab = new Tab("Viewer", this.viewerTab.getContent());
        this.tabPane.getTabs().addAll((Tab[])new Tab[]{streamTab, viewTab});
        root.setCenter(this.tabPane);
        Scene scene = new Scene(root, 1000.0, 750.0);
        scene.getStylesheets().add(this.getClass().getResource("/styles.css") != null ? this.getClass().getResource("/styles.css").toExternalForm() : "");
        this.stage.setScene(scene);
        this.stage.setOnCloseRequest(e -> {
            this.streamerTab.cleanup();
            this.viewerTab.cleanup();
        });
    }

    public void show() {
        this.stage.show();
    }
}

