/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.awt.Color;
import org.bytedeco.javacv.BaseChildSettings;
import org.bytedeco.javacv.CameraDevice;
import org.bytedeco.javacv.ColorCalibrator;
import org.bytedeco.javacv.JavaCV;
import org.bytedeco.javacv.MarkedPlane;
import org.bytedeco.javacv.Marker;
import org.bytedeco.javacv.MarkerDetector;
import org.bytedeco.javacv.ProjectorDevice;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.CvArr;
import org.bytedeco.opencv.opencv_core.CvMat;
import org.bytedeco.opencv.opencv_core.CvPoint;
import org.bytedeco.opencv.opencv_core.CvScalar;
import org.bytedeco.opencv.opencv_core.IplImage;

public class ProCamColorCalibrator {
    private Settings settings;
    private MarkerDetector markerDetector = null;
    private MarkedPlane boardPlane = null;
    private CameraDevice camera = null;
    private ProjectorDevice projector = null;
    private Color[] projectorColors = null;
    private Color[] cameraColors = null;
    private int counter = 0;
    private CvMat boardSrcPts;
    private CvMat boardDstPts;
    private CvMat projSrcPts;
    private CvMat projDstPts;
    private CvMat camKinv;
    private IplImage mask;
    private IplImage mask2;
    private IplImage undistImage;
    private static ThreadLocal<CvMat> H3x3 = CvMat.createThreadLocal(3, 3);
    private static ThreadLocal<CvMat> R3x3 = CvMat.createThreadLocal(3, 3);
    private static ThreadLocal<CvMat> t3x1 = CvMat.createThreadLocal(3, 1);
    private static ThreadLocal<CvMat> n3x1 = CvMat.createThreadLocal(3, 1);
    private static ThreadLocal<CvMat> z3x1 = CvMat.createThreadLocal(3, 1);

    public ProCamColorCalibrator(Settings settings, MarkerDetector.Settings detectorSettings, MarkedPlane boardPlane, CameraDevice camera, ProjectorDevice projector) {
        this.settings = settings;
        this.markerDetector = new MarkerDetector(detectorSettings);
        this.boardPlane = boardPlane;
        this.camera = camera;
        this.projector = projector;
        Marker[] boardMarkers = boardPlane.getMarkers();
        this.boardSrcPts = CvMat.create(4 + boardMarkers.length * 4, 1, 6, 2);
        this.boardDstPts = CvMat.create(4 + boardMarkers.length * 4, 1, 6, 2);
        this.boardSrcPts.put(0.0, 0.0, boardPlane.getWidth(), 0.0, boardPlane.getWidth(), boardPlane.getHeight(), 0.0, boardPlane.getHeight());
        for (int i = 0; i < boardMarkers.length; ++i) {
            this.boardSrcPts.put(8 + i * 8, boardMarkers[i].corners);
        }
        this.projSrcPts = CvMat.create(4, 1, 6, 2);
        this.projDstPts = CvMat.create(4, 1, 6, 2);
        this.projSrcPts.put(0.0, 0.0, projector.imageWidth - 1, 0.0, projector.imageWidth - 1, projector.imageHeight - 1, 0.0, projector.imageHeight - 1);
        this.camKinv = CvMat.create(3, 3);
        opencv_core.cvInvert(camera.cameraMatrix, this.camKinv);
    }

    public int getColorCount() {
        return this.counter;
    }

    public Color[] getProjectorColors() {
        double invgamma = 1.0 / this.projector.getSettings().getResponseGamma();
        int s = this.settings.samplesPerChannel;
        if (this.projectorColors == null) {
            this.projectorColors = new Color[s * s * s];
            this.cameraColors = new Color[s * s * s];
            for (int i = 0; i < this.projectorColors.length; ++i) {
                int j = i / s;
                int k = j / s;
                double r = Math.pow((double)(i % s) / (double)(s - 1), invgamma);
                double g = Math.pow((double)(j % s) / (double)(s - 1), invgamma);
                double b = Math.pow((double)(k % s) / (double)(s - 1), invgamma);
                this.projectorColors[i] = new Color((float)r, (float)g, (float)b);
            }
        }
        return this.projectorColors;
    }

    public Color getProjectorColor() {
        return this.getProjectorColors()[this.counter];
    }

    public Color[] getCameraColors() {
        return this.cameraColors;
    }

    public Color getCameraColor() {
        return this.getCameraColors()[this.counter];
    }

    public void addCameraColor() {
        ++this.counter;
    }

    public void addCameraColor(Color color) {
        this.cameraColors[this.counter++] = color;
    }

    public IplImage getMaskImage() {
        return this.mask;
    }

    public IplImage getUndistortedCameraImage() {
        return this.undistImage;
    }

    public boolean processCameraImage(IplImage cameraImage) {
        if (this.undistImage == null || this.undistImage.width() != cameraImage.width() || this.undistImage.height() != cameraImage.height() || this.undistImage.depth() != cameraImage.depth()) {
            this.undistImage = cameraImage.clone();
        }
        if (this.mask == null || this.mask2 == null || this.mask.width() != cameraImage.width() || this.mask2.width() != cameraImage.width() || this.mask.height() != cameraImage.height() || this.mask2.height() != cameraImage.width()) {
            this.mask = IplImage.create(cameraImage.width(), cameraImage.height(), 8, 1, cameraImage.origin());
            this.mask2 = IplImage.create(cameraImage.width(), cameraImage.height(), 8, 1, cameraImage.origin());
        }
        CvMat H = H3x3.get();
        CvMat R = R3x3.get();
        CvMat t = t3x1.get();
        CvMat n = n3x1.get();
        CvMat z = z3x1.get();
        z.put(0.0, 0.0, 1.0);
        this.camera.undistort(cameraImage, this.undistImage);
        Marker[] detectedBoardMarkers = this.markerDetector.detect(this.undistImage, false);
        if ((double)detectedBoardMarkers.length >= (double)this.boardPlane.getMarkers().length * this.settings.detectedBoardMin) {
            int j;
            this.boardPlane.getTotalWarp(detectedBoardMarkers, H);
            opencv_core.cvPerspectiveTransform(this.boardSrcPts, this.boardDstPts, H);
            double[] boardPts = this.boardDstPts.get();
            opencv_core.cvMatMul(this.camKinv, H, R);
            double error2 = JavaCV.HnToRt(R, z, R, t);
            opencv_core.cvMatMul(R, z, n);
            double d = opencv_core.cvDotProduct(t, z);
            opencv_core.cvGEMM(this.projector.T, n, -1.0 / d, this.projector.R, 1.0, H, 2);
            opencv_core.cvMatMul(this.projector.cameraMatrix, H, H);
            opencv_core.cvMatMul(H, this.camKinv, H);
            opencv_core.cvConvertScale(H, H, 1.0 / H.get(8), 0.0);
            opencv_core.cvInvert(H, H);
            opencv_core.cvConvertScale(H, H, 1.0 / H.get(8), 0.0);
            opencv_core.cvPerspectiveTransform(this.projSrcPts, this.projDstPts, H);
            double[] projPts = this.projDstPts.get();
            opencv_core.cvSetZero(this.mask);
            double cx = 0.0;
            double cy = 0.0;
            for (j = 0; j < 4; ++j) {
                cx += boardPts[j * 2];
                cy += boardPts[j * 2 + 1];
            }
            cx /= 4.0;
            cy /= 4.0;
            for (j = 0; j < 4; ++j) {
                int n2 = j * 2;
                boardPts[n2] = boardPts[n2] - (boardPts[j * 2] - cx) * this.settings.trimmingFraction;
                int n3 = j * 2 + 1;
                boardPts[n3] = boardPts[n3] - (boardPts[j * 2 + 1] - cy) * this.settings.trimmingFraction;
            }
            opencv_imgproc.cvFillConvexPoly((CvArr)this.mask, new CvPoint(4L).put((byte)16, boardPts, 0, 8), 4, CvScalar.WHITE, 8, 16);
            for (j = 0; j < (boardPts.length - 8) / 8; ++j) {
                opencv_imgproc.cvFillConvexPoly((CvArr)this.mask, new CvPoint(4L).put((byte)16, boardPts, 8 + j * 8, 8), 4, CvScalar.BLACK, 8, 16);
            }
            opencv_core.cvSetZero(this.mask2);
            cx = 0.0;
            cy = 0.0;
            for (j = 0; j < 4; ++j) {
                cx += projPts[j * 2];
                cy += projPts[j * 2 + 1];
            }
            cx /= 4.0;
            cy /= 4.0;
            for (j = 0; j < 4; ++j) {
                int n4 = j * 2;
                projPts[n4] = projPts[n4] - (projPts[j * 2] - cx) * this.settings.trimmingFraction;
                int n5 = j * 2 + 1;
                projPts[n5] = projPts[n5] - (projPts[j * 2 + 1] - cy) * this.settings.trimmingFraction;
            }
            opencv_imgproc.cvFillConvexPoly((CvArr)this.mask2, new CvPoint(4L).put((byte)16, projPts, 0, 8), 4, CvScalar.WHITE, 8, 16);
            opencv_core.cvAnd(this.mask, this.mask2, this.mask, null);
            opencv_imgproc.cvErode(this.mask, this.mask, null, 1);
            CvScalar c = opencv_core.cvAvg(this.undistImage, this.mask);
            int[] o = this.camera.getRGBColorOrder();
            double s = cameraImage.highValue();
            this.cameraColors[this.counter] = new Color((float)(c.val(o[0]) / s), (float)(c.val(o[1]) / s), (float)(c.val(o[2]) / s));
            return true;
        }
        return false;
    }

    public double calibrate() {
        Color[] cc = this.getCameraColors();
        Color[] pc = this.getProjectorColors();
        assert (this.counter == pc.length);
        ColorCalibrator calibrator = new ColorCalibrator(this.projector);
        this.projector.avgColorErr = calibrator.calibrate(cc, pc);
        this.camera.colorMixingMatrix = CvMat.create(3, 3);
        this.camera.additiveLight = CvMat.create(3, 1);
        opencv_core.cvSetIdentity(this.camera.colorMixingMatrix);
        opencv_core.cvSetZero(this.camera.additiveLight);
        this.counter = 0;
        return this.projector.avgColorErr;
    }

    public static class Settings
    extends BaseChildSettings {
        int samplesPerChannel = 4;
        double trimmingFraction = 0.01;
        double detectedBoardMin = 0.5;

        public int getSamplesPerChannel() {
            return this.samplesPerChannel;
        }

        public void setSamplesPerChannel(int samplesPerChannel) {
            this.samplesPerChannel = samplesPerChannel;
        }

        public double getDetectedBoardMin() {
            return this.detectedBoardMin;
        }

        public void setDetectedBoardMin(double detectedBoardMin) {
            this.detectedBoardMin = detectedBoardMin;
        }
    }
}

