/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.content.Context;
import android.graphics.Bitmap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.opencv.core.CvException;
import org.opencv.core.Mat;
import org.opencv.imgcodecs.Imgcodecs;

public class Utils {
    public static String exportResource(Context context2, int resourceId) {
        return Utils.exportResource(context2, resourceId, "OpenCV_data");
    }

    public static String exportResource(Context context2, int resourceId, String dirname) {
        String fullname = context2.getResources().getString(resourceId);
        String resName = fullname.substring(fullname.lastIndexOf("/") + 1);
        try {
            int bytesRead;
            InputStream is = context2.getResources().openRawResource(resourceId);
            File resDir = context2.getDir(dirname, 0);
            File resFile = new File(resDir, resName);
            FileOutputStream os = new FileOutputStream(resFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            is.close();
            os.close();
            return resFile.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CvException("Failed to export resource " + resName + ". Exception thrown: " + e);
        }
    }

    public static Mat loadResource(Context context2, int resourceId) throws IOException {
        return Utils.loadResource(context2, resourceId, -1);
    }

    public static Mat loadResource(Context context2, int resourceId, int flags) throws IOException {
        int bytesRead;
        InputStream is = context2.getResources().openRawResource(resourceId);
        ByteArrayOutputStream os = new ByteArrayOutputStream(is.available());
        byte[] buffer = new byte[4096];
        while ((bytesRead = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
        is.close();
        Mat encoded = new Mat(1, os.size(), 0);
        encoded.put(0, 0, os.toByteArray());
        os.close();
        Mat decoded = Imgcodecs.imdecode(encoded, flags);
        encoded.release();
        return decoded;
    }

    public static void bitmapToMat(Bitmap bmp, Mat mat, boolean unPremultiplyAlpha) {
        if (bmp == null) {
            throw new IllegalArgumentException("bmp == null");
        }
        if (mat == null) {
            throw new IllegalArgumentException("mat == null");
        }
        Utils.nBitmapToMat2(bmp, mat.nativeObj, unPremultiplyAlpha);
    }

    public static void bitmapToMat(Bitmap bmp, Mat mat) {
        Utils.bitmapToMat(bmp, mat, false);
    }

    public static void matToBitmap(Mat mat, Bitmap bmp, boolean premultiplyAlpha) {
        if (mat == null) {
            throw new IllegalArgumentException("mat == null");
        }
        if (bmp == null) {
            throw new IllegalArgumentException("bmp == null");
        }
        Utils.nMatToBitmap2(mat.nativeObj, bmp, premultiplyAlpha);
    }

    public static void matToBitmap(Mat mat, Bitmap bmp) {
        Utils.matToBitmap(mat, bmp, false);
    }

    private static native void nBitmapToMat2(Bitmap var0, long var1, boolean var3);

    private static native void nMatToBitmap2(long var0, Bitmap var2, boolean var3);
}

