/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.dnn;

import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfRect;
import org.opencv.dnn.Model;
import org.opencv.dnn.Net;

public class DetectionModel
extends Model {
    protected DetectionModel(long addr) {
        super(addr);
    }

    public static DetectionModel __fromPtr__(long addr) {
        return new DetectionModel(addr);
    }

    public DetectionModel(String model, String config) {
        super(DetectionModel.DetectionModel_0(model, config));
    }

    public DetectionModel(String model) {
        super(DetectionModel.DetectionModel_1(model));
    }

    public DetectionModel(Net network) {
        super(DetectionModel.DetectionModel_2(network.nativeObj));
    }

    public DetectionModel setNmsAcrossClasses(boolean value) {
        return new DetectionModel(DetectionModel.setNmsAcrossClasses_0(this.nativeObj, value));
    }

    public boolean getNmsAcrossClasses() {
        return DetectionModel.getNmsAcrossClasses_0(this.nativeObj);
    }

    public void detect(Mat frame2, MatOfInt classIds, MatOfFloat confidences, MatOfRect boxes, float confThreshold, float nmsThreshold) {
        MatOfInt classIds_mat = classIds;
        MatOfFloat confidences_mat = confidences;
        MatOfRect boxes_mat = boxes;
        DetectionModel.detect_0(this.nativeObj, frame2.nativeObj, classIds_mat.nativeObj, confidences_mat.nativeObj, boxes_mat.nativeObj, confThreshold, nmsThreshold);
    }

    public void detect(Mat frame2, MatOfInt classIds, MatOfFloat confidences, MatOfRect boxes, float confThreshold) {
        MatOfInt classIds_mat = classIds;
        MatOfFloat confidences_mat = confidences;
        MatOfRect boxes_mat = boxes;
        DetectionModel.detect_1(this.nativeObj, frame2.nativeObj, classIds_mat.nativeObj, confidences_mat.nativeObj, boxes_mat.nativeObj, confThreshold);
    }

    public void detect(Mat frame2, MatOfInt classIds, MatOfFloat confidences, MatOfRect boxes) {
        MatOfInt classIds_mat = classIds;
        MatOfFloat confidences_mat = confidences;
        MatOfRect boxes_mat = boxes;
        DetectionModel.detect_2(this.nativeObj, frame2.nativeObj, classIds_mat.nativeObj, confidences_mat.nativeObj, boxes_mat.nativeObj);
    }

    @Override
    protected void finalize() throws Throwable {
        DetectionModel.delete(this.nativeObj);
    }

    private static native long DetectionModel_0(String var0, String var1);

    private static native long DetectionModel_1(String var0);

    private static native long DetectionModel_2(long var0);

    private static native long setNmsAcrossClasses_0(long var0, boolean var2);

    private static native boolean getNmsAcrossClasses_0(long var0);

    private static native void detect_0(long var0, long var2, long var4, long var6, long var8, float var10, float var11);

    private static native void detect_1(long var0, long var2, long var4, long var6, long var8, float var10);

    private static native void detect_2(long var0, long var2, long var4, long var6, long var8);

    private static native void delete(long var0);
}

