/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.dnn;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.dnn.Model;
import org.opencv.dnn.Net;
import org.opencv.utils.Converters;

public class TextRecognitionModel
extends Model {
    protected TextRecognitionModel(long addr) {
        super(addr);
    }

    public static TextRecognitionModel __fromPtr__(long addr) {
        return new TextRecognitionModel(addr);
    }

    public TextRecognitionModel(Net network) {
        super(TextRecognitionModel.TextRecognitionModel_0(network.nativeObj));
    }

    public TextRecognitionModel(String model, String config) {
        super(TextRecognitionModel.TextRecognitionModel_1(model, config));
    }

    public TextRecognitionModel(String model) {
        super(TextRecognitionModel.TextRecognitionModel_2(model));
    }

    public TextRecognitionModel setDecodeType(String decodeType) {
        return new TextRecognitionModel(TextRecognitionModel.setDecodeType_0(this.nativeObj, decodeType));
    }

    public String getDecodeType() {
        return TextRecognitionModel.getDecodeType_0(this.nativeObj);
    }

    public TextRecognitionModel setDecodeOptsCTCPrefixBeamSearch(int beamSize, int vocPruneSize) {
        return new TextRecognitionModel(TextRecognitionModel.setDecodeOptsCTCPrefixBeamSearch_0(this.nativeObj, beamSize, vocPruneSize));
    }

    public TextRecognitionModel setDecodeOptsCTCPrefixBeamSearch(int beamSize) {
        return new TextRecognitionModel(TextRecognitionModel.setDecodeOptsCTCPrefixBeamSearch_1(this.nativeObj, beamSize));
    }

    public TextRecognitionModel setVocabulary(List<String> vocabulary) {
        return new TextRecognitionModel(TextRecognitionModel.setVocabulary_0(this.nativeObj, vocabulary));
    }

    public List<String> getVocabulary() {
        return TextRecognitionModel.getVocabulary_0(this.nativeObj);
    }

    public String recognize(Mat frame2) {
        return TextRecognitionModel.recognize_0(this.nativeObj, frame2.nativeObj);
    }

    public void recognize(Mat frame2, List<Mat> roiRects, List<String> results) {
        Mat roiRects_mat = Converters.vector_Mat_to_Mat(roiRects);
        TextRecognitionModel.recognize_1(this.nativeObj, frame2.nativeObj, roiRects_mat.nativeObj, results);
    }

    @Override
    protected void finalize() throws Throwable {
        TextRecognitionModel.delete(this.nativeObj);
    }

    private static native long TextRecognitionModel_0(long var0);

    private static native long TextRecognitionModel_1(String var0, String var1);

    private static native long TextRecognitionModel_2(String var0);

    private static native long setDecodeType_0(long var0, String var2);

    private static native String getDecodeType_0(long var0);

    private static native long setDecodeOptsCTCPrefixBeamSearch_0(long var0, int var2, int var3);

    private static native long setDecodeOptsCTCPrefixBeamSearch_1(long var0, int var2);

    private static native long setVocabulary_0(long var0, List<String> var2);

    private static native List<String> getVocabulary_0(long var0);

    private static native String recognize_0(long var0, long var2);

    private static native void recognize_1(long var0, long var2, long var4, List<String> var6);

    private static native void delete(long var0);
}

