/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config.gui;

import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.ConfigEntryList;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.ConfigScreen;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.BooleanValueConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.CategoryTitleConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.ColorValueConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.ConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.EnumValueConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.IntegerValueConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.KeyValueConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.PrefixTextConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.tree.CategoryConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ValueConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3675;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import net.minecraft.class_8209;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigCategoryTab<C>
implements class_8087 {
    private final ConfigScreen<C> screen;
    private final CategoryConfigNode<C> category;
    private final C config;
    private final class_2561 title;
    private final class_2561 titleChanged;
    private final class_2561 titleError;
    private final class_2561 titleErrorChanged;
    private final ConfigEntryList list;
    @Nullable
    private ValueConfigNode<C, Key, Key> selectedKeyNode;
    @Nullable
    private class_8209 tabButton;

    public ConfigCategoryTab(ConfigScreen<C> screen, CategoryConfigNode<C> category, C config) {
        this.screen = screen;
        this.category = category;
        this.config = config;
        this.title = category.getTitle();
        this.titleChanged = this.title.method_27661().method_27692(class_124.field_1056);
        this.titleError = this.title.method_27661().method_27692(class_124.field_1061);
        this.titleErrorChanged = this.title.method_27661().method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
        ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>();
        for (ConfigNode node : category.getChildren()) {
            if (node.getPrefix() != null) {
                entries.add(new PrefixTextConfigEntry(this, node.getPrefix()));
            }
            if (node instanceof ValueConfigNode) {
                ValueConfigNode valueNode = (ValueConfigNode)node;
                entries.add(this.createValueEntry(valueNode));
                continue;
            }
            if (!(node instanceof CategoryConfigNode)) continue;
            CategoryConfigNode categoryNode = (CategoryConfigNode)node;
            entries.addAll(this.createSubCategoryEntries(categoryNode));
        }
        this.list = new ConfigEntryList(this, this.getMinecraft(), this.screen.field_22789, this.screen.field_22790 - this.screen.getHeaderHeight() - this.screen.getFooterHeight(), 0, 24, entries);
    }

    @NotNull
    public class_2561 method_48610() {
        return this.title;
    }

    @NotNull
    public class_2561 method_71245() {
        return class_2561.method_43473();
    }

    public void method_48612(Consumer<class_339> consumer) {
        consumer.accept((class_339)this.list);
    }

    public void method_48611(class_8030 screenRectangle) {
        this.list.method_55444(screenRectangle.comp_1196(), screenRectangle.comp_1197(), screenRectangle.method_49620(), screenRectangle.method_49618());
    }

    private <T, V> ConfigEntry createValueEntry(ValueConfigNode<C, T, V> valueNode) {
        Class<T> type = valueNode.getType();
        if (type.equals(Boolean.class)) {
            return new BooleanValueConfigEntry<C>(this, valueNode);
        }
        if (ColorKey.class.isAssignableFrom(type)) {
            return new ColorValueConfigEntry<C>(this, valueNode);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return new EnumValueConfigEntry<C, T>(this, valueNode);
        }
        if (type.equals(Integer.class)) {
            return new IntegerValueConfigEntry<C>(this, valueNode);
        }
        if (Key.class.isAssignableFrom(type)) {
            return new KeyValueConfigEntry<C>(this, valueNode);
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
    }

    private List<ConfigEntry> createSubCategoryEntries(CategoryConfigNode<C> categoryNode) {
        ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>(categoryNode.getChildren().size() + 1);
        entries.add(new CategoryTitleConfigEntry(this, categoryNode.getTitle()));
        for (ConfigNode node : categoryNode.getChildren()) {
            if (!(node instanceof ValueConfigNode)) continue;
            ValueConfigNode valueNode = (ValueConfigNode)node;
            entries.add(this.createValueEntry(valueNode));
        }
        return entries;
    }

    @NotNull
    public class_310 getMinecraft() {
        return Objects.requireNonNull(this.screen.getMinecraft());
    }

    public ConfigScreen<C> getScreen() {
        return this.screen;
    }

    @Nullable
    public ValueConfigNode<C, Key, Key> getSelectedKeyNode() {
        return this.selectedKeyNode;
    }

    public void setSelectedKeyNode(@Nullable ValueConfigNode<C, Key, Key> selectedKeyNode) {
        this.selectedKeyNode = selectedKeyNode;
    }

    public void refresh() {
        boolean hasError;
        if (this.tabButton == null) {
            return;
        }
        boolean hasChanged = !this.category.isActiveValue(this.config);
        boolean bl = hasError = this.category.validate(this.config) != null;
        class_2561 newTitle = hasError ? (hasChanged ? this.titleErrorChanged : this.titleError) : (hasChanged ? this.titleChanged : this.title);
        this.tabButton.method_25355(newTitle);
        this.list.refreshEntries();
    }

    public C getConfig() {
        return this.config;
    }

    public boolean keyPressed(int keyCode, int scanCode) {
        if (this.selectedKeyNode != null) {
            if (keyCode == 256) {
                this.selectedKeyNode.setEditingValue(Key.UNKNOWN_KEY);
            } else {
                this.selectedKeyNode.setEditingValue(new Key(class_3675.method_15985((int)keyCode, (int)scanCode)));
            }
            this.selectedKeyNode = null;
            this.screen.refresh();
            return true;
        }
        return false;
    }

    public void setTabButton(@Nullable class_8209 tabButton) {
        this.tabButton = tabButton;
    }
}

