/*
 * Decompiled with CFR 0.152.
 */
package b100.fullscreenfix;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;

@Environment(value=EnvType.CLIENT)
public class MonitorInfo {
    public final long handle;
    public final int posX;
    public final int posY;
    public final int width;
    public final int height;
    public final int refreshRate;

    public static MonitorInfo getMonitor(class_1041 window) {
        return MonitorInfo.getMonitor(window.method_4490());
    }

    public static MonitorInfo getMonitor(long window) {
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetWindowPos((long)window, (int[])x, (int[])y);
        int[] w = new int[1];
        int[] h = new int[1];
        GLFW.glfwGetWindowSize((long)window, (int[])w, (int[])h);
        return MonitorInfo.getMonitorAt(x[0] + w[0] / 2, y[0] + h[0] / 2);
    }

    public static MonitorInfo getMonitorAt(int x, int y) {
        PointerBuffer monitorPointers = GLFW.glfwGetMonitors();
        for (int i = monitorPointers.position(); i < monitorPointers.limit(); ++i) {
            long monitor = monitorPointers.get(i);
            MonitorInfo info = new MonitorInfo(monitor);
            if (x < info.posX || y < info.posY || x >= info.posX + info.width || y >= info.posY + info.height) continue;
            return info;
        }
        return new MonitorInfo(GLFW.glfwGetPrimaryMonitor());
    }

    public MonitorInfo(long monitor) {
        this.handle = monitor;
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)monitor);
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetMonitorPos((long)monitor, (int[])x, (int[])y);
        this.posX = x[0];
        this.posY = y[0];
        this.width = vidmode.width();
        this.height = vidmode.height();
        this.refreshRate = vidmode.refreshRate();
    }
}

