/*
 * Decompiled with CFR 0.152.
 */
package b100.fullscreenfix;

import b100.fullscreenfix.FullscreenFix;
import b100.fullscreenfix.MonitorInfo;
import b100.fullscreenfix.util.GLFWUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.glfw.GLFWVidMode;

@Environment(value=EnvType.CLIENT)
public class VideoMode {
    public final long monitor;
    public final GLFWVidMode vidMode;

    public VideoMode(long monitor, GLFWVidMode vidMode) {
        this.monitor = monitor;
        this.vidMode = vidMode;
    }

    public static VideoMode parse(String string) {
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        int x = 0;
        int y = 0;
        int monitorWidth = 0;
        int monitorHeight = 0;
        int width = 0;
        int height = 0;
        int refreshRate = 0;
        String[] str = string.split(";");
        for (int i = 0; i < str.length; ++i) {
            String entry = str[i];
            int j = entry.indexOf(58);
            String key = entry.substring(0, j);
            int value = Integer.parseInt(entry.substring(j + 1));
            if (key.equals("x")) {
                x = value;
                continue;
            }
            if (key.equals("y")) {
                y = value;
                continue;
            }
            if (key.equals("monitorWidth")) {
                monitorWidth = value;
                continue;
            }
            if (key.equals("monitorHeight")) {
                monitorHeight = value;
                continue;
            }
            if (key.equals("width")) {
                width = value;
                continue;
            }
            if (key.equals("height")) {
                height = value;
                continue;
            }
            if (!key.equals("refreshRate")) continue;
            refreshRate = value;
        }
        long monitor = GLFWUtil.findMonitor(x, y, monitorWidth, monitorHeight);
        if (monitor == 0L) {
            FullscreenFix.print("Could not find monitor " + monitorWidth + " x " + monitorHeight + " at " + x + ", " + y);
            FullscreenFix.print("Available monitors: ");
            for (long m : GLFWUtil.getMonitors()) {
                MonitorInfo info = new MonitorInfo(m);
                FullscreenFix.print("    " + info.width + " x " + info.height + " at " + info.posX + ", " + info.posY);
            }
            return null;
        }
        GLFWVidMode vidMode = GLFWUtil.getMonitorVidMode(monitor, width, height, refreshRate);
        if (vidMode == null) {
            FullscreenFix.print("Could not find matching vidmode: " + width + " x " + height + " @ " + refreshRate + "hz");
            return null;
        }
        return new VideoMode(monitor, vidMode);
    }

    public String toString() {
        return this.vidMode.width() + " x " + this.vidMode.height() + " @ " + this.vidMode.refreshRate() + "hz";
    }

    public String toConfigString() {
        MonitorInfo monitorInfo = new MonitorInfo(this.monitor);
        return "x:" + monitorInfo.posX + ";y:" + monitorInfo.posY + ";monitorWidth:" + monitorInfo.width + ";monitorHeight:" + monitorInfo.height + ";width:" + this.vidMode.width() + ";height:" + this.vidMode.height() + ";refreshRate:" + this.vidMode.refreshRate();
    }

    public static boolean compare(VideoMode o1, VideoMode o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.monitor == o2.monitor && o1.vidMode.equals((Object)o2.vidMode);
    }
}

