/*
 * Decompiled with CFR 0.152.
 */
package b100.fullscreenfix.mixin;

import b100.fullscreenfix.FullscreenFix;
import b100.fullscreenfix.Global;
import b100.fullscreenfix.MonitorInfo;
import b100.fullscreenfix.VideoMode;
import b100.fullscreenfix.util.GLFWUtil;
import b100.fullscreenfix.util.Win32Util;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_319;
import net.minecraft.class_323;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1041.class})
public abstract class WindowMixin {
    @Shadow
    private boolean field_5191;
    @Shadow
    private class_323 field_5195;
    private boolean wasFullscreen = false;
    private boolean initialized = false;
    private boolean fullscreenModeHasChanged = false;
    private class_319 newFullscreenMode;
    private boolean isMaximized = false;
    private int windowPosX;
    private int windowPosY;
    private int windowWidth;
    private int windowHeight;
    private boolean windowMaximized;
    private boolean firstUpdate = true;

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwWindowHint(II)V", ordinal=0)})
    private void onSetupWindowHints(CallbackInfo info) {
        FullscreenFix.debugPrint("Setup Window Hints");
        FullscreenFix.debugPrint("Fullscreen: " + this.field_5191);
        GLFW.glfwWindowHint((int)131078, (int)1);
        GLFW.glfwWindowHint((int)131075, (int)1);
        GLFW.glfwWindowHint((int)131077, (int)1);
        GLFW.glfwWindowHint((int)131076, (int)0);
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwSetFramebufferSizeCallback(JLorg/lwjgl/glfw/GLFWFramebufferSizeCallbackI;)Lorg/lwjgl/glfw/GLFWFramebufferSizeCallback;")})
    private void postInit(CallbackInfo info) {
        FullscreenFix.debugPrint("PostInit");
        FullscreenFix.debugPrint("Fullscreen: " + this.field_5191);
        FullscreenFix.setWindow((class_1041)this);
        int[] i = new int[1];
        int[] j = new int[1];
        GLFW.glfwGetWindowSize((long)this.method_4490(), (int[])i, (int[])j);
        int width = i[0];
        int height = j[0];
        MonitorInfo monitor = new MonitorInfo(GLFW.glfwGetPrimaryMonitor());
        int x = (monitor.width - width) / 2;
        int y = (monitor.height - height) / 2;
        GLFW.glfwSetWindowPos((long)this.method_4490(), (int)x, (int)y);
        this.windowPosX = x;
        this.windowPosY = y;
        this.windowWidth = width;
        this.windowHeight = height;
        GLFW.glfwShowWindow((long)this.method_4490());
        this.initialized = true;
        GLFW.glfwSetWindowMaximizeCallback((long)this.method_4490(), (window, maximized) -> {
            this.isMaximized = maximized;
        });
    }

    @Inject(method={"swapBuffers"}, at={@At(value="TAIL")})
    private void onSwapBuffers(CallbackInfo ci) {
        if (FullscreenFix.windowNeedsUpdate) {
            FullscreenFix.windowNeedsUpdate = false;
            this.updateWindowState();
        }
    }

    @Inject(method={"updateWindowRegion"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateWindowRegion(CallbackInfo ci) {
        FullscreenFix.debugPrint("Update Window Region");
        ci.cancel();
        if (!this.initialized) {
            FullscreenFix.debugPrint("Not initialized!");
            return;
        }
        this.updateWindowState();
        this.wasFullscreen = this.field_5191;
    }

    private void updateWindowState() {
        FullscreenFix.debugPrint("Update Window State");
        if (!this.wasFullscreen) {
            this.windowMaximized = this.isMaximized;
            if (!this.isMaximized) {
                long handle = this.method_4490();
                int[] i = new int[1];
                int[] j = new int[1];
                GLFW.glfwGetWindowPos((long)handle, (int[])i, (int[])j);
                this.windowPosX = i[0];
                this.windowPosY = j[0];
                GLFW.glfwGetWindowSize((long)handle, (int[])i, (int[])j);
                this.windowWidth = i[0];
                this.windowHeight = j[0];
                FullscreenFix.debugPrint("Window Size: " + this.windowWidth + " x " + this.windowHeight + " at " + this.windowPosX + ", " + this.windowPosY + ", max: " + this.windowMaximized);
            } else {
                FullscreenFix.debugPrint("Window maximized: " + this.windowMaximized);
            }
        }
        if (this.firstUpdate) {
            this.firstUpdate = false;
            if (FullscreenFix.isFullscreenEnabled() && !FullscreenFix.isStartInFullscreenEnabled()) {
                FullscreenFix.print("Start in fullscreen is disabled, turning off fullscreen");
                FullscreenFix.setFullscreen(false);
            }
        }
        if (this.fullscreenModeHasChanged) {
            this.fullscreenModeHasChanged = false;
            if (this.newFullscreenMode == null) {
                FullscreenFix.setFullscreenVideoMode(null);
            } else {
                GLFWVidMode glfwVidMode = GLFWUtil.findMatchingVidMode(this.newFullscreenMode);
                if (glfwVidMode == null) {
                    FullscreenFix.print("Could not find matching GLFW VideoMode: " + this.newFullscreenMode.method_1668() + " x " + this.newFullscreenMode.method_1669() + " @ " + this.newFullscreenMode.method_1671() + "hz");
                    FullscreenFix.setFullscreenVideoMode(null);
                } else {
                    FullscreenFix.setFullscreenVideoMode(new VideoMode(GLFW.glfwGetPrimaryMonitor(), glfwVidMode));
                }
            }
        }
        class_1041 window = (class_1041)this;
        long handle = this.method_4490();
        if (Global.OS_WINDOWS) {
            Win32Util.updateWindowState(window, this.windowPosX, this.windowPosY, this.windowWidth, this.windowHeight, this.windowMaximized);
            FullscreenFix.windowNeedsUpdate = false;
            return;
        }
        GLFW.glfwHideWindow((long)handle);
        VideoMode fullscreenMode = FullscreenFix.getFullscreenVideoMode();
        if (this.field_5191 && fullscreenMode != null) {
            FullscreenFix.print("Change to Fullscreen with custom resolution");
            MonitorInfo monitorInfo = new MonitorInfo(fullscreenMode.monitor);
            GLFW.glfwSetWindowMonitor((long)window.method_4490(), (long)fullscreenMode.monitor, (int)monitorInfo.posX, (int)monitorInfo.posY, (int)fullscreenMode.vidMode.width(), (int)fullscreenMode.vidMode.height(), (int)fullscreenMode.vidMode.refreshRate());
        } else if (this.field_5191 && !FullscreenFix.isBorderlessEnabled()) {
            FullscreenFix.print("Change to Fullscreen");
            GLFW.glfwSetWindowAttrib((long)handle, (int)131078, (int)(FullscreenFix.isAutoMinimizeEnabled() ? 1 : 0));
            MonitorInfo monitor = MonitorInfo.getMonitor(window);
            GLFWUtil.enableFullscreen(window, monitor);
        } else {
            if (GLFWUtil.isFullscreen(window)) {
                GLFWUtil.disableFullscreen(window, this.windowPosX, this.windowPosY, this.windowWidth, this.windowHeight);
            }
            if (this.field_5191 && FullscreenFix.isBorderlessEnabled()) {
                FullscreenFix.print("Change to Borderless Fullscreen");
                MonitorInfo monitor = MonitorInfo.getMonitor(window);
                GLFW.glfwSetWindowAttrib((long)handle, (int)131077, (int)0);
                GLFW.glfwSetWindowPos((long)handle, (int)monitor.posX, (int)monitor.posY);
                GLFW.glfwSetWindowSize((long)handle, (int)monitor.width, (int)monitor.height);
            } else {
                FullscreenFix.print("Change to Windowed");
                GLFW.glfwSetWindowAttrib((long)handle, (int)131077, (int)1);
                GLFW.glfwSetWindowPos((long)handle, (int)this.windowPosX, (int)this.windowPosY);
                GLFW.glfwSetWindowSize((long)handle, (int)this.windowWidth, (int)this.windowHeight);
            }
        }
        GLFW.glfwShowWindow((long)handle);
        FullscreenFix.windowNeedsUpdate = false;
    }

    @Inject(method={"setFullscreenVideoMode"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetFullscreenVideoMode(Optional<class_319> optional, CallbackInfo ci) {
        FullscreenFix.print("Set Fullscreen Mode: " + String.valueOf(optional));
        this.newFullscreenMode = optional.isPresent() ? optional.get() : null;
        this.fullscreenModeHasChanged = true;
    }

    @Shadow
    public abstract long method_4490();
}

