/*
 * Decompiled with CFR 0.152.
 */
package b100.fullscreenfix.util;

import b100.fullscreenfix.FullscreenFix;
import b100.fullscreenfix.MonitorInfo;
import b100.fullscreenfix.VideoMode;
import b100.fullscreenfix.util.GLFWUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.system.windows.User32;

@Environment(value=EnvType.CLIENT)
public class Win32Util {
    public static long getWin32Handle(class_1041 window) {
        return Win32Util.getWin32Handle(window.method_4490());
    }

    public static long getWin32Handle(long window) {
        long hwnd = GLFWNativeWin32.glfwGetWin32Window((long)window);
        if (hwnd == 0L) {
            throw new NullPointerException("No Win32 Handle!");
        }
        return hwnd;
    }

    public static void updateWindowState(class_1041 window, int windowPosX, int windowPosY, int windowWidth, int windowHeight, boolean windowWasMaximized) {
        boolean fullscreen = window.method_4498();
        boolean borderless = FullscreenFix.isBorderlessEnabled();
        boolean optimizations = FullscreenFix.isWindowsFullscreenOptimizationsEnabled();
        VideoMode fullscreenMode = FullscreenFix.getFullscreenVideoMode();
        long hwnd = Win32Util.getWin32Handle(window);
        if (fullscreen && fullscreenMode != null) {
            FullscreenFix.print("Change to Fullscreen with custom resolution");
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131077, (int)1);
            Win32Util.setWindowStyle(hwnd, 0x10000000L);
            GLFW.glfwHideWindow((long)window.method_4490());
            MonitorInfo monitorInfo = new MonitorInfo(fullscreenMode.monitor);
            GLFW.glfwSetWindowMonitor((long)window.method_4490(), (long)fullscreenMode.monitor, (int)monitorInfo.posX, (int)monitorInfo.posY, (int)fullscreenMode.vidMode.width(), (int)fullscreenMode.vidMode.height(), (int)fullscreenMode.vidMode.refreshRate());
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)(FullscreenFix.isAutoMinimizeEnabled() ? 1 : 0));
            GLFW.glfwShowWindow((long)window.method_4490());
            GLFW.glfwFocusWindow((long)window.method_4490());
        } else if (!fullscreen) {
            if (windowWasMaximized) {
                FullscreenFix.print("Change to Maximized Windowed Mode");
            } else {
                FullscreenFix.print("Change to Windowed Mode");
            }
            if (GLFWUtil.isFullscreen(window)) {
                GLFWUtil.disableFullscreen(window, windowPosX, windowPosY, windowWidth, windowHeight);
            }
            Win32Util.setDefaultWindowStyle(window, hwnd);
            GLFW.glfwSetWindowPos((long)window.method_4490(), (int)windowPosX, (int)windowPosY);
            GLFW.glfwSetWindowSize((long)window.method_4490(), (int)windowWidth, (int)windowHeight);
            if (windowWasMaximized) {
                GLFW.glfwMaximizeWindow((long)window.method_4490());
            }
        } else if (borderless && !optimizations) {
            FullscreenFix.print("Change to Borderless Fullscreen without Fullscreen optimizations");
            GLFWUtil.disableFullscreen(window, windowPosX, windowPosY, windowWidth, windowHeight);
            MonitorInfo monitor = MonitorInfo.getMonitor(window);
            GLFWUtil.enableFullscreen(window, monitor);
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)0);
            User32.SetWindowPos((long)hwnd, (long)-2L, (int)0, (int)0, (int)0, (int)0, (int)3);
            Win32Util.setWindowStyle(hwnd, 369754112L);
            Win32Util.setWindowExtendedStyle(hwnd, 34340880L);
        } else if (borderless && optimizations) {
            FullscreenFix.print("Change to Borderless Fullscreen with Fullscreen optimizations");
            if (GLFWUtil.isFullscreen(window)) {
                GLFWUtil.disableFullscreen(window, windowPosX, windowPosY, windowWidth, windowHeight);
            }
            Win32Util.setDefaultWindowStyle(window, hwnd);
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131077, (int)0);
            MonitorInfo monitor = MonitorInfo.getMonitor(window);
            GLFW.glfwSetWindowPos((long)window.method_4490(), (int)monitor.posX, (int)monitor.posY);
            GLFW.glfwSetWindowSize((long)window.method_4490(), (int)monitor.width, (int)monitor.height);
        } else {
            FullscreenFix.print("Change to GLFW Fullscreen");
            GLFWUtil.disableFullscreen(window, windowPosX, windowPosY, windowWidth, windowHeight);
            Win32Util.setDefaultWindowStyle(window, hwnd);
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)(FullscreenFix.isAutoMinimizeEnabled() ? 1 : 0));
            MonitorInfo monitor = MonitorInfo.getMonitor(window);
            GLFWUtil.enableFullscreen(window, monitor);
        }
    }

    public static void setDefaultWindowStyle(class_1041 window, long hwnd) {
        GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131077, (int)1);
        long style = 0x10000000L;
        style |= 0xC00000L;
        style |= 0x80000L;
        style |= 0x10000L;
        style |= 0x20000L;
        Win32Util.setWindowStyle(hwnd, style |= 0x40000L);
    }

    public static void setAlwaysOnTop(long hwnd, boolean alwaysOnTop) {
        if (alwaysOnTop) {
            User32.SetWindowPos((long)hwnd, (long)-1L, (int)0, (int)0, (int)0, (int)0, (int)3);
        } else {
            User32.SetWindowPos((long)hwnd, (long)-2L, (int)0, (int)0, (int)0, (int)0, (int)3);
        }
    }

    public static void setWindowStyle(long hwnd, long style) {
        User32.SetWindowLongPtr((long)hwnd, (int)-16, (long)style);
    }

    public static void setWindowExtendedStyle(long hwnd, long style) {
        User32.SetWindowLongPtr((long)hwnd, (int)-20, (long)style);
    }
}

