/*
 * Decompiled with CFR 0.152.
 */
package b100.gui;

import b100.gui.ActionListener;
import b100.gui.FocusListener;
import b100.gui.Focusable;
import b100.gui.GuiElement;
import b100.gui.GuiScreen;
import b100.gui.ListenerList;
import b100.gui.Textures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5348;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class GuiButton
extends GuiElement
implements Focusable {
    public GuiScreen screen;
    public class_2561 text;
    private boolean clickable = true;
    private boolean focused = false;
    public final ListenerList<ActionListener> actionListeners = new ListenerList(this);
    public final ListenerList<FocusListener> focusListeners = new ListenerList(this);

    public GuiButton(GuiScreen screen, class_2561 text) {
        this.screen = screen;
        this.text = text;
        this.width = 200;
        this.height = 20;
    }

    @Override
    public void draw() {
        class_2960 texture = this.clickable ? (this.focused || this.screen.isMouseOver(this) ? Textures.INSTANCE.buttonHover : Textures.INSTANCE.buttonNormal) : Textures.INSTANCE.buttonDisabled;
        this.utils.drawGuiTexture(texture, this.posX, this.posY, this.width, this.height);
        if (this.text != null) {
            int textWidth = this.utils.textRenderer.method_27525((class_5348)this.text);
            int textX = this.posX + (this.width - textWidth) / 2;
            int textY = this.posY + this.height / 2 - 4;
            this.utils.drawString(this.text, textX, textY, 0xFFFFFF, true);
        }
    }

    @Override
    public boolean keyEvent(int key, int scancode, int modifiers, boolean pressed) {
        if (pressed && this.focused && (key == 257 || key == 32)) {
            this.clickButton();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
        if (this.clickable && pressed && this.screen.isMouseOver(this)) {
            this.clickButton();
            return true;
        }
        return super.mouseEvent(button, pressed, mouseX, mouseY);
    }

    public void clickButton() {
        this.utils.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
        this.actionListeners.forEach(listener -> listener.actionPerformed(this));
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused != this.focused) {
            this.focused = focused;
            this.focusListeners.forEach(listener -> listener.focusChanged(this));
        }
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public boolean isFocusable() {
        return this.clickable;
    }

    @Override
    public ListenerList<FocusListener> getFocusListeners() {
        return this.focusListeners;
    }

    public ListenerList<ActionListener> getActionListeners() {
        return this.actionListeners;
    }

    public GuiButton addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
        return this;
    }

    public boolean removeActionListener(ActionListener actionListener) {
        return this.actionListeners.remove(actionListener);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[x=" + this.posX + ",y=" + this.posY + ",w=" + this.width + ",h=" + this.height + ",text=" + (this.text != null ? this.text.getString() : null) + "]";
    }
}

