#define DENOISE

// Textures //
uniform sampler2D depthtex0;
uniform sampler2D colortex0; // Albedo
uniform sampler2D colortex1; // Normals
uniform sampler2D colortex7; // Render

// Uniforms //
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;

// Constants //
ivec2 ScreenSize = ivec2(viewWidth*RenderScale, viewHeight*RenderScale);

// In //
in vec2 TextureUV;

// Out //
/* RENDERTARGETS: 7 */
layout (location = 0) out vec4 FragColor;

// Code //
float linearizeDepthFast(float depth) {
    return (near * far) / (depth * (near - far) + far);
}

vec3 SimilarityDenoise(int Size){
    vec3 Color = vec3(0);
    vec3 MyNormal = texture(colortex1, TextureUV).rgb*2.0-1.0;
    float MyDepth = linearizeDepthFast(texture(depthtex0, TextureUV).r);
    vec3 PixelAlbedo = texture(colortex0, TextureUV).rgb;
    float Total = 0.0;

    for (int y = -Size; y < Size; y++){
        for (int x = -Size; x < Size; x++){
            vec2 uv = TextureUV + vec2(x,y) / vec2(ScreenSize);
            vec3 uvNormal = texture(colortex1, uv).rgb*2.0-1.0;
            float uvDepth = linearizeDepthFast(texture(depthtex0, uv).r);
            if (abs(uvDepth - MyDepth) > MyDepth/50.0) continue;
            if (PixelAlbedo != texture(colortex0, TextureUV).rgb) continue;
            if (uvNormal == MyNormal || dot(uvNormal, MyNormal) > 0.9999){
                float PixelDist = length(vec2(x,y) / float(Size));
                float Factor = 1.0 / max(1.0 + pow(PixelDist*(Similarity_Denoiser_Falloff+2.0), Similarity_Denoiser_Falloff+2.0), 2.5);
                Color += texture(colortex7, uv).rgb * Factor;
                Total += Factor;
            }
        }
    }

    return Color / Total;
}

void main(){
    #ifdef Render 
        FragColor = texture(colortex7, TextureUV);
    #else
        #ifdef Similarity_Denoiser
            FragColor = vec4(SimilarityDenoise(Similarity_Denoiser_SampleArea), 1.0);
        #else
            FragColor = texture(colortex7, TextureUV);
        #endif
    #endif
}