#define ATMOSPHERE

#ifndef RENDER_STRUCTURES
    #include RenderStructures.glsl
#endif
#ifndef SETTINGS
    #include Settings.glsl
#endif

// uniforms //
uniform bool hasSkylight;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform int moonPhase;
uniform int biome_category;
uniform vec3 skyColor;
uniform vec3 fogColor;

// Constants //
const vec3 SunPos = mat3(gbufferModelViewInverse) * sunPosition * 15.0;
const vec3 MoonPos = mat3(gbufferModelViewInverse) * moonPosition * 15.0;
const float DaySkyFactor = clamp((normalize(SunPos).y + 0.2)*2.0, 0.0, 1.0);

const vec3 SunColor = vec3(SunColorRed, SunColorGreen, SunColorBlue);
const vec3 MoonColor = vec3(MoonColorRed, MoonColorGreen, MoonColorBlue);
const vec3 SunHorizonColor = SunColor*vec3(1.0, 0.45, 0.3)*2.2;
const vec3 MoonHorizonColor = MoonColor*1.4;
const vec3 FogColor = mix(vec3(10, 11, 19)/255.0, vec3(177, 205, 252)/255.0, DaySkyFactor);
const vec3 SkyColor = mix(vec3(4, 4, 8)/255.0, vec3(129, 171, 252)/255.0, DaySkyFactor);

vec3 Private_SampleAurora(RayStr Ray){
    return vec3(0);
}

vec3 Private_GetSkyColor(vec3 Direction){
    Direction.y = max(Direction.y, 0.0);
    float Factor = 0.25 / (Direction.y * Direction.y + 0.25);
    return mix(SkyColor, FogColor, Factor);
}

vec3 Private_GetVanillaSkyColor(vec3 Direction){
    Direction.y = max(Direction.y, 0.0);
    float Factor = 0.25 / (Direction.y * Direction.y + 0.25);
    return mix(skyColor, fogColor, Factor);
}

vec3 Atmosphere_SampleSky(RayStr Ray){
    if (!hasSkylight){
        if (biome_category != CAT_THE_END) return vec3(0);
        return vec3(19, 14, 26)/255.0;
    }
    
    vec3 AuroraColor = vec3(0);
    if (moonPhase == 4 && sunPosition.y < 0.0){
        AuroraColor = Private_SampleAurora(Ray);
    }

    vec3 Color = Private_GetSkyColor(Ray.Direction);
    
    float SunsetFactor = (1.0 - min(abs(normalize(SunPos).y)*4.0, 1.0))*pow(abs(dot(normalize(SunPos), Ray.Direction)), 4.0);
    vec3 SunsetColor = mix(SunHorizonColor, MoonHorizonColor, (dot(-Ray.Direction, normalize(SunPos)) + 1.0) / 2.0);
    return mix(Color, SunsetColor, SunsetFactor);
}

vec3 Atmosphere_SampleVanillaSky(RayStr Ray){
    if (!hasSkylight){
        if (biome_category != CAT_THE_END) return vec3(0);
        return vec3(19, 14, 26)/255.0;
    }
    return Private_GetVanillaSkyColor(Ray.Direction);
}