#define MATERIALS

#ifndef Epsilon
    #define Epsilon 0.001
#endif

uniform sampler2D BlockNormal; // Block normal texture atlas
uniform sampler2D BlockSpecular; // Block specular texture atlas
uniform sampler2D BlockAlbedo; // Block texture atlas

// Includes //
#ifndef SETTINGS
    #include Settings.glsl
#endif

// Constants //
ivec2 BlockAtlasSize = textureSize(BlockAlbedo, 0);

vec3 GetTintFromPacked(uint Packed){
    vec3 Tint = vec3(0);
    Tint.r = float(Packed >> 24);
    Tint.g = float((Packed >> 16) & 255u);
    Tint.b = float((Packed >> 8) & 255u);
    return Tint/255.0;
}

// Eventually correctly calculate TBN for correct mapping
vec2 Material_GetVoxelUVOffset(RayStr Ray, vec3 Normal, ivec3 VoxelPos){
    vec3 RayMod = mod(Ray.Origin, 1.0);
    if (Normal.x != 0.0){
        if (sign(Normal.x) == 1.0) return vec2(1.0-RayMod.z, 1.0-RayMod.y);
        return vec2(RayMod.z, RayMod.y);
    }
    if (Normal.y != 0.0) return vec2(RayMod.x, RayMod.z);
    if (Normal.z != 0.0){
        if (sign(Normal.z) == 1.0) return vec2(1.0-RayMod.x, RayMod.y);
        return vec2(RayMod.x, RayMod.y);
    }
}

vec2 Material_GetVoxelUV(RayStr Ray, vec3 Normal, ivec3 VoxelPos, int ID){
    return (VoxelTextureData[ID].TextureCoords.xy + Material_GetVoxelUVOffset(Ray, Normal, VoxelPos)*VoxelTextureData[ID].TextureCoords.z) / vec2(BlockAtlasSize);
}

vec3 Material_GetVoxelNormal(RayStr Ray, ivec3 VoxelPos){
    vec3 Center = vec3(VoxelPos) + 0.5;
    vec3 Offset = Ray.Origin - Center;
    if (abs(Offset.x) > max(abs(Offset.y), abs(Offset.z))) return vec3(sign(Offset.x), 0.0, 0.0);
    if (abs(Offset.y) > abs(Offset.z)) return vec3(0.0, sign(Offset.y), 0.0);
    return vec3(0.0, 0.0, sign(Offset.z));
}

void Material_SetToTextureNormal(inout vec3 Normal, in vec2 VoxelTextureUV){
    vec2 NormalTex = texture(BlockNormal, VoxelTextureUV).xy;
    vec3 TextureNormal = normalize(vec3((NormalTex*2.0-1.0) * NormalMapStrength, sqrt(dot(NormalTex, NormalTex))));
    if (Normal.x != 0.0){
        Normal = TextureNormal.zyx * vec3(Normal.x, 1.0, Normal.x);
        Normal.z = -Normal.z;
        return;
    }
    if (Normal.y != 0.0){
        Normal = TextureNormal.xzy * vec3(1.0, Normal.y, 1.0);
        return;
    }
    if (Normal.z != 0.0){
        Normal = TextureNormal.xyz * vec3(-Normal.z, 1.0, Normal.z);
    }
}

MaterialStr Material_GetFromSpecular(vec4 Specular){
    float Emission = BlockLightEmissionStrength * fract(Specular.a) * 255.0 / 254.0;
    float Roughness = pow(1.0 - Specular.r, 2.0);
    float F0 = (Specular.g / 0.9);
    //F0 = min(Specular.g / 0.9, 1.0);
    //return MaterialStr(vec4(0.0), Emission, 1.0, 0.0);
    return MaterialStr(vec4(0.0), Emission, Roughness, F0);
}

void Material_GetFromVoxel(RayStr Ray, inout HitDataStr HitData){
    ivec3 VoxelPos = ivec3(Ray.Origin + Ray.Direction * Epsilon);
    int VoxelID = VoxelPos.x + (VoxelPos.y * Voxelization_Distance) + (VoxelPos.z * Voxelization_Distance * Voxelization_Distance);

    HitData.Normal = Material_GetVoxelNormal(Ray, VoxelPos);
    vec2 VoxelTextureUV = Material_GetVoxelUV(Ray, HitData.Normal, VoxelPos, VoxelID);
    Material_SetToTextureNormal(HitData.Normal, VoxelTextureUV);
    HitData.Material = Material_GetFromSpecular(texture(BlockSpecular, VoxelTextureUV));
    HitData.Material.Color = texture(BlockAlbedo, VoxelTextureUV) * vec4(GetTintFromPacked(VoxelTextureData[VoxelID].Tint), 1.0);
    HitData.Material.Color.rgb = pow(HitData.Material.Color.rgb, vec3(Camera_Gamma));
}