#define RAYCAST
#define Epsilon 0.002

// Constants //
const float MaxDist = 256.0;
const int MinimumLOD = 0;

void PointRayTowards(inout RayStr Ray, vec3 Point){
    Ray.Direction = normalize(Point-Ray.Origin);
}

bool GetLODVoxel(int ID, int LOD){
    switch (LOD){
        case 3: return ((LOD3[ID/32] & (1u << (ID % 32))) != 0); break;
        case 2: return ((LOD2[ID/32] & (1u << (ID % 32))) != 0); break;
        case 1: return ((LOD1[ID/32] & (1u << (ID % 32))) != 0); break;
        case 0: return ((LOD0[ID/32] & (1u << (ID % 32))) != 0); break;
    }
    return false;
}

float VoxelIntersection(RayStr Ray){
    vec3 TravelPos = Ray.Origin + Ray.Direction * Epsilon;
    vec3 Step = abs(1.0 / Ray.Direction);
    float t = 0.0;

    int LOD = 0;
    const int MaximumSteps = 2 * Intersection_Distance;
    int iter = 0;
    for (iter; iter < MaximumSteps; iter++){
        int LODSize = 1 << LOD;
        ivec3 Voxel = ivec3(floor(TravelPos / LODSize));
        int ID = Voxel.x + int(Voxel.y*Voxelization_Distance / LODSize) + int(Voxel.z*Voxelization_Distance*Voxelization_Distance / (LODSize * LODSize));

        if (int(TravelPos.x) >= Voxelization_Distance || int(TravelPos.y) >= Voxelization_Distance || int(TravelPos.z) >= Voxelization_Distance) return -1;
        if (int(TravelPos.x) < 0 || int(TravelPos.y) < 0 || int(TravelPos.z) < 0) return -1;

        if (GetLODVoxel(ID, LOD)){
            if (LOD == MinimumLOD){
                return t;
            } else{
                LOD -= 1;
                continue;
            }
        } else if (LOD < 3){
            int NextLODSize = 1 << (LOD + 1);
            ivec3 NextLODVoxel = ivec3(floor(TravelPos / NextLODSize));
            ID = NextLODVoxel.x + int(NextLODVoxel.y*Voxelization_Distance / NextLODSize) + int(NextLODVoxel.z*Voxelization_Distance*Voxelization_Distance / (NextLODSize*NextLODSize));
            if (!GetLODVoxel(ID, LOD + 1)){
                LODSize = NextLODSize;
                Voxel = NextLODVoxel;
                LOD += 1;
            }
        }

        vec3 Next = (vec3(Voxel) + vec3(Ray.Direction.x > 0.0, Ray.Direction.y > 0.0, Ray.Direction.z > 0.0) - (Ray.Origin / LODSize)) / Ray.Direction;

        t = (min(min(Next.x, Next.y), Next.z)) * LODSize;
        TravelPos = Ray.Origin + Ray.Direction * (t+Epsilon);

        if (int(TravelPos.x) >= Voxelization_Distance || int(TravelPos.y) >= Voxelization_Distance || int(TravelPos.z) >= Voxelization_Distance) return -1;
        if (int(TravelPos.x) < 0 || int(TravelPos.y) < 0 || int(TravelPos.z) < 0) return -1;

        Voxel = ivec3(floor(TravelPos / LODSize));
        ID = Voxel.x + int(Voxel.y*Voxelization_Distance / LODSize) + int(Voxel.z*Voxelization_Distance*Voxelization_Distance / (LODSize*LODSize));
        
        if (GetLODVoxel(ID, LOD)){
            if (LOD == MinimumLOD){
                return t;
            } else{
                LOD -= 1;
                continue;
            }
        }
        if (t > float(Intersection_Distance)) return -1.0;
    }
    return -1.0;
}

HitDataStr GetIntersection(RayStr Ray, float MaxDist){
    HitDataStr HitData = HitDataStr(MaxDist, vec3(0), BaseMaterial);
    float t = VoxelIntersection(Ray);
    if (t < HitData.t && !(t < Epsilon)){
        HitData.t = t;
    }
    return HitData;
}