#define VOXELIZE

// Uniforms //
uniform vec3 cameraPosition;
uniform mat4 gbufferModelViewInverse;

// Includes //
#ifndef VOXELMAPS
    #include VoxelMaps.glsl
#endif

// Constants //
const vec3 EyeCameraPosition = cameraPosition + gbufferModelViewInverse[3].xyz;

// Code //
// Stores in LOD buffer and returns the VoxelDataMap ID for use
int Voxelize(ivec3 GridPos){
    // Center on player
    ivec3 OffsetBlockPos = GridPos - ivec3(floor(EyeCameraPosition)) + ivec3(Voxelization_Distance / 2);

    // Test if out of bounds
    if (OffsetBlockPos.x >= Voxelization_Distance || OffsetBlockPos.y >= Voxelization_Distance || OffsetBlockPos.z >= Voxelization_Distance ||
        OffsetBlockPos.x < 0 || OffsetBlockPos.y < 0 || OffsetBlockPos.z < 0) return -1;

    // Get respective positions in each LOD
    ivec3 LODBlock1 = OffsetBlockPos / 2;
    ivec3 LODBlock2 = OffsetBlockPos / 4;
    ivec3 LODBlock3 = OffsetBlockPos / 8;
    
    // Get array index for each LOD
    int VoxelID0 = OffsetBlockPos.x + (OffsetBlockPos.y * Voxelization_Distance) + (OffsetBlockPos.z * Voxelization_Distance * Voxelization_Distance);
    int VoxelID1 = LODBlock1.x + (LODBlock1.y * Voxelization_Distance / 2) + (LODBlock1.z * Voxelization_Distance * Voxelization_Distance / 4);
    int VoxelID2 = LODBlock2.x + (LODBlock2.y * Voxelization_Distance / 4) + (LODBlock2.z * Voxelization_Distance * Voxelization_Distance / 16);
    int VoxelID3 = LODBlock3.x + (LODBlock3.y * Voxelization_Distance / 8) + (LODBlock3.z * Voxelization_Distance * Voxelization_Distance / 64);

    // Write that a voxel exists in appropriate index
    // Pack bits by treating each bit in a integer (32 bit number) as an array index
    atomicOr(LOD0[VoxelID0/32], 1u << (VoxelID0 % 32));
    atomicOr(LOD1[VoxelID1/32], 1u << (VoxelID1 % 32));
    atomicOr(LOD2[VoxelID2/32], 1u << (VoxelID2 % 32));
    atomicOr(LOD3[VoxelID3/32], 1u << (VoxelID3 % 32));

    // Return VoxelDataMap ID
    return VoxelID0;
}