#version 430 compatibility

// Textures
uniform sampler2D lightmap;
uniform sampler2D gtexture;
uniform sampler2D specular;

// Uniforms //
uniform vec4 entityColor;

uniform mat4 gbufferModelViewInverse;
uniform vec3 cameraPosition;

// In //
in vec2 TextureUV;
in vec2 LightMapUV;
in vec4 glcolor;

in vec3 WorldPos;
in vec3 VertexNormal;

// Out //
/* DRAWBUFFERS: 012*/
layout(location = 0) out vec4 Albedo;
layout(location = 1) out vec4 Normal;
layout(location = 2) out vec4 Specular;

// Includes //
#include Utility/Settings.glsl
#include Utility/VoxelMaps.glsl

// Code //
void main() {
	Albedo = texture(gtexture, TextureUV) * glcolor;
	Albedo.rgb = mix(Albedo.rgb, entityColor.rgb, entityColor.a);
    Normal = vec4(VertexNormal / 2.0 + 0.5, 1.0);
    Specular = texture(specular, TextureUV);

	if (Albedo.a < 0.1) {
		discard;
	}
}