#version 430 compatibility

uniform int entityId;

// Out //
out vec2 TextureUV;
out vec2 LightMapUV;
out vec4 glcolor;

out vec3 WorldPos;
out vec3 VertexNormal;

// Includes //
#include Utility/Settings.glsl
#include Utility/Voxelize.glsl

void main() {
	gl_Position = ftransform();
	TextureUV = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
	LightMapUV = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
	glcolor = gl_Color;
    VertexNormal = gl_Normal;

    #ifndef Settings_Exclude_Non_Voxels
        if (entityId == 1000) return;

        WorldPos = vec3( ( mat3(gbufferModelViewInverse) * (gl_ModelViewMatrix*gl_Vertex).xyz ) + EyeCameraPosition );
        ivec3 CenterPos = ivec3(floor(WorldPos));
        Voxelize(CenterPos);
    #endif
}